<?php
/**
 * API: فحص التحديثات
 * Endpoint: /api/updates
 */

define('API_ACCESS', true);
require_once 'config.php';

// التحقق من الطلب
verify_request(array('license_key', 'site_url', 'current_version', 'plugin'));

$license_key = sanitize_text_field($_POST['license_key']);
$site_url = sanitize_text_field($_POST['site_url']);
$current_version = sanitize_text_field($_POST['current_version']);
$plugin = sanitize_text_field($_POST['plugin']);

// تنظيف URL
$site_url = rtrim($site_url, '/');
$site_url = str_replace(array('http://', 'https://'), '', $site_url);

try {
    // التحقق من الترخيص
    $stmt = $pdo->prepare("
        SELECT l.*, a.id as activation_id
        FROM licenses l
        LEFT JOIN activations a ON l.id = a.license_id AND a.site_url = :site_url
        WHERE l.license_key = :license_key
    ");

    $stmt->execute(array(
        ':license_key' => $license_key,
        ':site_url' => $site_url
    ));

    $license = $stmt->fetch();

    // معلومات آخر إصدار (يمكن تخزينها في قاعدة البيانات أو ملف config)
    $latest_version = '1.0.0'; // النسخة الحالية
    $download_url = 'https://yoursite.com/downloads/author-box-pro-' . $latest_version . '.zip';

    // إذا كان هناك ترخيص صالح، أضف مفتاح التحميل
    if ($license && $license['activation_id']) {
        $download_url .= '?key=' . $license_key;
    }

    // معلومات التحديث
    $update_info = array(
        'name' => 'Author Box Pro',
        'slug' => 'author-box-pro',
        'version' => $latest_version,
        'author' => 'Your Name',
        'homepage' => 'https://yoursite.com/author-box-pro',
        'requires' => '5.0',
        'tested' => '6.4',
        'requires_php' => '7.2',
        'download_url' => $download_url,
        'sections' => array(
            'description' => 'بطاقة احترافية لعرض معلومات الكُتّاب في المقالات',
            'changelog' => '
                <h4>الإصدار ' . $latest_version . '</h4>
                <ul>
                    <li>الإصدار الأول</li>
                    <li>نظام الترخيص والاشتراكات</li>
                    <li>3 قوالب تصميم</li>
                </ul>
            '
        )
    );

    // التحقق من وجود تحديث
    if (version_compare($current_version, $latest_version, '<')) {
        send_json_response($update_info);
    } else {
        send_json_response(array(
            'message' => 'No updates available'
        ));
    }

} catch (Exception $e) {
    send_json_response(array(
        'error' => 'Server error'
    ), 500);
}

function sanitize_text_field($str)
{
    return htmlspecialchars(strip_tags(trim($str)), ENT_QUOTES, 'UTF-8');
}
