<?php
/**
 * API: إلغاء تفعيل الترخيص
 * Endpoint: /api/deactivate-license
 */

define('API_ACCESS', true);
require_once 'config.php';

// التحقق من الطلب والتوقيع الرقمي
verify_request(array('license_key', 'site_url'));

$license_key = sanitize_text_field($_POST['license_key']);
$site_url = sanitize_text_field($_POST['site_url']);

// تنظيف URL
$site_url = rtrim($site_url, '/');
$site_url = str_replace(array('http://', 'https://'), '', $site_url);

try {
    // البحث عن الترخيص
    $stmt = $pdo->prepare("
        SELECT * FROM licenses 
        WHERE license_key = :license_key
    ");

    $stmt->execute(array(':license_key' => $license_key));
    $license = $stmt->fetch();

    if (!$license) {
        send_json_response(array(
            'success' => false,
            'message' => 'License not found'
        ), 404);
    }

    // حذف التفعيل
    $stmt = $pdo->prepare("
        DELETE FROM activations 
        WHERE license_id = :license_id 
        AND site_url = :site_url
    ");

    $stmt->execute(array(
        ':license_id' => $license['id'],
        ':site_url' => $site_url
    ));

    $deleted = $stmt->rowCount();

    // تسجيل الحدث
    if ($deleted > 0) {
        $pdo->prepare("
            INSERT INTO license_logs (license_id, action, details, ip_address)
            VALUES (:license_id, 'deactivate', :details, :ip)
        ")->execute(array(
                    ':license_id' => $license['id'],
                    ':details' => json_encode(array('site_url' => $site_url)),
                    ':ip' => $_SERVER['REMOTE_ADDR']
                ));
    }

    send_json_response(array(
        'success' => true,
        'message' => 'تم إلغاء التفعيل بنجاح',
        'deleted' => $deleted
    ));

} catch (Exception $e) {
    send_json_response(array(
        'success' => false,
        'message' => 'Server error'
    ), 500);
}

function sanitize_text_field($str)
{
    return htmlspecialchars(strip_tags(trim($str)), ENT_QUOTES, 'UTF-8');
}
