<?php
/**
 * إعدادات سيرفر التراخيص
 * License Server Configuration
 */

// منع الوصول المباشر
if (!defined('API_ACCESS')) {
    die('Direct access not permitted');
}

// إعدادات قاعدة البيانات
define('DB_HOST', 'localhost');
define('DB_NAME', 'boxpluseonline_saas');
define('DB_USER', 'boxpluseonline_saas');
define('DB_PASS', 'QNMkjR@x{J8DQ=5u');

// إعدادات الأمان
define('API_SECRET_KEY', 'abp_sec_f8a92b1c4d0e6f3a7e9d2c1b4a0f');

// إعدادات تليجرام (اختياري)
define('TELEGRAM_TOKEN', ''); // ضع توكن البوت هنا
define('TELEGRAM_CHAT_ID', ''); // ضع ID الخاص بك هنا

// الاتصال بقاعدة البيانات
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        )
    );
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(array(
        'success' => false,
        'message' => 'Database connection failed'
    ));
    exit;
}

/**
 * إرسال استجابة JSON
 */
function send_json_response($data, $status_code = 200)
{
    http_response_code($status_code);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

/**
 * توليد توقيع للطلب
 */
function generate_signature($data, $secret)
{
    ksort($data); // ترتيب الحقول أبجدياً
    $string = http_build_query($data) . $secret;
    return hash('sha256', $string);
}

/**
 * التحقق من التوقيع
 */
function verify_signature($data, $received_signature, $secret)
{
    if (empty($received_signature))
        return false;
    $expected_signature = generate_signature($data, $secret);
    return hash_equals($expected_signature, $received_signature);
}

/**
 * إرسال تنبيه لتليجرام
 */
function send_telegram_alert($message)
{
    if (empty(TELEGRAM_TOKEN) || empty(TELEGRAM_CHAT_ID))
        return;

    $url = "https://api.telegram.org/bot" . TELEGRAM_TOKEN . "/sendMessage";
    $data = array(
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML'
    );

    $options = array(
        'http' => array(
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
        ),
    );
    $context = stream_context_create($options);
    @file_get_contents($url, false, $context);
}

/**
 * توليد مفتاح ترخيص
 */
function generate_license_key()
{
    $segments = array();
    for ($i = 0; $i < 4; $i++) {
        $segments[] = strtoupper(substr(md5(uniqid(rand(), true)), 0, 4));
    }
    return implode('-', $segments);
}

/**
 * التحقق من صلاحية الطلب
 */
function verify_request($required_fields = array(), $check_signature = true)
{
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            send_json_response(array(
                'success' => false,
                'message' => 'Missing required field: ' . $field
            ), 400);
        }
    }

    // التحقق من التوقيع الرقمي
    if ($check_signature) {
        $data = $_POST;
        $signature = $data['signature'] ?? '';
        unset($data['signature']); // حذف التوقيع من البيانات قبل الحساب

        if (!verify_signature($data, $signature, API_SECRET_KEY)) {
            send_json_response(array(
                'success' => false,
                'message' => 'Invalid request signature'
            ), 403);
        }
    }
}
